/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.search;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.toolkit.admin.search.IVWAdminPerformSearchListener;
import filenet.vw.toolkit.admin.search.VWAdminSearchCategoryPanel;
import filenet.vw.toolkit.admin.search.resources.VWResource;
import filenet.vw.toolkit.utils.VWDriverFrame;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JPanel;

public class VWAdminSearchPane
extends JPanel {
    private VWAdminSearchCategoryPanel m_searchCategoryPanel = null;
    private VWToolbarBorder m_border = null;

    public void init(Frame parentFrame) {
        try {
            this.setLayout(new BorderLayout());
            this.m_border = new VWToolbarBorder(VWResource.s_searchPane, 0);
            this.add((Component)this.m_border, "Center");
            this.m_searchCategoryPanel = new VWAdminSearchCategoryPanel(parentFrame, this);
            this.m_searchCategoryPanel.setDoubleBuffered(true);
            this.m_searchCategoryPanel.setOpaque(true);
            BorderLayout m_clientLayout = new BorderLayout();
            JPanel panel = this.m_border.getClientPanel();
            panel.setLayout(m_clientLayout);
            panel.add((Component)this.m_searchCategoryPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void main(String[] args) {
        try {
            VWDebug.init(VWLogger.ERROR);
            if (args.length < 3 || args.length > 0 && VWStringUtils.compare(args[0], "?") == 0) {
                System.out.println("Usage:  VWAdminSearchPane username password routername");
                System.exit(1);
            }
            VWSession session = new VWSession();
            session.logon(args[0], args[1], args[2]);
            VWDriverFrame frame = new VWDriverFrame();
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_searchPanePrefDim);
            if (dim == null) {
                dim = new Dimension(550, 350);
            }
            frame.setSize(dim.width, dim.height);
            frame.setLayout(new BorderLayout(0, 0));
            VWAdminSearchPane panel = new VWAdminSearchPane();
            panel.init(frame);
            panel.setSession(session);
            frame.add((Component)panel, "Center");
            frame.setVisible(true);
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    public void addPerformSearchListener(IVWAdminPerformSearchListener apsl) {
        if (this.m_searchCategoryPanel != null) {
            this.m_searchCategoryPanel.addPerformSearchListener(apsl);
        }
    }

    public void removePerformSearchListener(IVWAdminPerformSearchListener apsl) {
        if (this.m_searchCategoryPanel != null) {
            this.m_searchCategoryPanel.removePerformSearchListener(apsl);
        }
    }

    public void performFindNow() {
        if (this.m_searchCategoryPanel != null) {
            this.m_searchCategoryPanel.performFindNow();
        }
    }

    public void performNewSearch() {
        if (this.m_searchCategoryPanel != null) {
            this.m_searchCategoryPanel.performNewSearch();
        }
    }

    public void setSession(VWSession session) {
        if (this.m_searchCategoryPanel != null) {
            this.m_searchCategoryPanel.setSession(session);
            if (session == null) {
                this.m_searchCategoryPanel.removeReferences();
                this.m_searchCategoryPanel = null;
                this.m_border = null;
            }
        }
    }
}

